#!/bin/sh
#

BASH_BASE_SIZE=0x00000b32
CISCO_AC_TIMESTAMP=0x00000000624c79d2
CISCO_AC_OBJNAME=iseposture_uninstall.sh                                         
# BASH_BASE_SIZE=0x00000000 is required for signing
# the comment is after or else the code signing tool will find the comment

ANYCONNECT_INSTPREFIX="/opt/cisco/anyconnect"
ANYCONNECT_BINDIR="${ANYCONNECT_INSTPREFIX}/bin"
ANYCONNECT_LIBDIR="${ANYCONNECT_INSTPREFIX}/lib"
ANYCONNECT_PLUGINDIR="${ANYCONNECT_BINDIR}/plugins"
ISEPOSTURE_PROFILEDIR="${ANYCONNECT_INSTPREFIX}/iseposture"
ISEPOSTURE_SCRIPTDIR="${ISEPOSTURE_PROFILEDIR}/scripts"


LOGDIR="/var/log/anyconnect"
LOG="${LOGDIR}/iseposture-uninstall.log"

ISEBINFILES="aciseposture aciseagentd iseposture_uninstall.sh manifesttool_iseposture"
ISELIBFILES="libacise.so"
ISEPLUGINFILES="libacisectrl.so libaciseshim.so"

# Create log directory if not exist
if [ ! -d ${LOGDIR} ]; then
  mkdir -p ${LOGDIR} >/dev/null 2>&1
fi

echo "Uninstalling Cisco AnyConnect ISE Posture Module..."
echo "Uninstalling Cisco AnyConnect ISE Posture Module..." > "${LOG}"
echo `whoami` "invoked $0 from " `pwd` " at " `date` >> "${LOG}"

# Check for root privileges
if [ `id | sed -e 's/(.*//'` != "uid=0" ]; then
  echo "Sorry, you need super user privileges to run this script."
  echo "Sorry, you need super user privileges to run this script." >> "${LOG}"
  exit 1
fi

# update the VPNManifest.dat
ISEPOSTUREMANIFEST="ACManifestISEPosture.xml"
echo "${ANYCONNECT_BINDIR}/manifesttool_iseposture -x ${ANYCONNECT_INSTPREFIX} ${ANYCONNECT_INSTPREFIX}/${ISEPOSTUREMANIFEST}" >> "${LOG}"
${ANYCONNECT_BINDIR}/manifesttool_iseposture -x ${ANYCONNECT_INSTPREFIX} ${ANYCONNECT_INSTPREFIX}/${ISEPOSTUREMANIFEST} >> "${LOG}"

rm -f ${ANYCONNECT_INSTPREFIX}/${ISEPOSTUREMANIFEST}

# Remove those pre-deploy files that we may have installed

for f in ${ISEBINFILES}; do
    if [ -e ${ANYCONNECT_BINDIR}/$f ]; then
       echo "rm -rf ${ANYCONNECT_BINDIR}/$f" >> "${LOG}"
       rm -rf ${ANYCONNECT_BINDIR}/$f >> "${LOG}" 2>&1
    fi
done

for f in ${ISELIBFILES}; do
    if [ -e ${ANYCONNECT_LIBDIR}/$f ]; then
       echo "rm -rf ${ANYCONNECT_LIBDIR}/$f" >> "${LOG}"
       rm -rf ${ANYCONNECT_LIBDIR}/$f >> "${LOG}" 2>&1
    fi
done

for f in ${ISEPLUGINFILES}; do
    if [ -e ${ANYCONNECT_PLUGINDIR}/$f ]; then
       echo "rm -rf ${ANYCONNECT_PLUGINDIR}/$f" >> "${LOG}"
       rm -rf ${ANYCONNECT_PLUGINDIR}/$f >> "${LOG}" 2>&1
    fi
done

echo "rm -rf ${ISEPOSTURE_SCRIPTDIR}" >> "${LOG}"
rm -rf ${ISEPOSTURE_SCRIPTDIR} >> "${LOG}" 2>&1

# Remove ISE Posture profile directory
# TODO AKK 3.2 FCS - Do this only for non-upgrade uninstall: rm -rf ${ISEPOSTURE_PROFILEDIR} >> "${LOG}" 2>&1


echo "Successfully removed Cisco AnyConnect ISE Posture Module from the system." >> "${LOG}"
echo "Successfully removed Cisco AnyConnect ISE Posture Module from the system."

exit 0
  +S!cV!j!dqeayIVDMPT!A!kfkjvddSBJJJ!V!eznRGBF <080 SG!_+0
	*H
 0r10	UUS10U
DigiCert Inc10Uwww.digicert.com110/U(DigiCert SHA2 Assured ID Code Signing CA0
210317000000Z
240321235959Z0v10	UUS10U
Massachusetts10U
Boxborough10U
Cisco Systems, Inc.10UCisco Systems, Inc.0"0
	*H
  0
 t27)7%}XA1%'%WR<_vE(NWˏq-ax.$y@t˕-NkkkJq{.{9YyrBИ
Tk{L=%z P66{ x&/jR؟ 
+t<7h[Xh㤹hsi[etvRZa6=QV 00U#0ZĹ{*
q`-euX0U:ov݈4[H0U0U%0
+0wUp0n0531/http://crl3.digicert.com/sha2-assured-cs-g1.crl0531/http://crl4.digicert.com/sha2-assured-cs-g1.crl0KU D0B06	`Hl0)0'+http://www.digicert.com/CPS0g0+x0v0$+0http://ocsp.digicert.com0N+0Bhttp://cacerts.digicert.com/DigiCertSHA2AssuredIDCodeSigningCA.crt0U0 0
	*H
  !laia<5ߛW	긎F~7֝ SIe6AYb<$!6)ApD>ˋEyh
SVz$w9VFZ3>
/3N
- AT#sNˡzU|&ιkvlH2}.G4QFꁇmz~W
]
AS/k*Sr9B\Q8n(R!8QUbʥXGi8Ofk9y7 4000	_ջfuSCoP0
	*H
 0e10	UUS10U
DigiCert Inc10Uwww.digicert.com1$0"UDigiCert Assured ID Root CA0
131022120000Z
281022120000Z0r10	UUS10U
DigiCert Inc10Uwww.digicert.com110/U(DigiCert SHA2 Assured ID Code Signing CA0"0
	*H
  0
 ӳgw1IE:D娝2qv.C7׶𜆥%y(:~g)'{##w#fT3Pt(&$iRgE-, JM`Ĳp1f3q>p|˒;1
WJt+l~t96
Nj
gN %#d>RŎ,QsbsA8js ds<3% 00U0 0U0U%0
+0y+m0k0$+0http://ocsp.digicert.com0C+07http://cacerts.digicert.com/DigiCertAssuredIDRootCA.crt0Uz0x0:864http://crl4.digicert.com/DigiCertAssuredIDRootCA.crl0:864http://crl3.digicert.com/DigiCertAssuredIDRootCA.crl0OU H0F08
`Hl 0*0(+https://www.digicert.com/CPS0
`Hl0UZĹ{*
q`-euX0U#0E뢯˂1-Q!m0
	*H
  >
Z$",|%)v]-:0a~`=į* U7ђuQnZ^$N?qcK_Dy6FN\Q$$'*)(:q(<.%Gzhh\ \qh@@Dd%B26$/r~IEYtdkfCڳ
 Ι1c=OƓIbnS.hlD2fdQ  =//j؁-2OQz\BWq΀4
HPJgތܮ7ݗYǌ9:4>6[ep	w wܷ޴!8;b#
<YV͒,Yk>kj|q!PW
lDlFboAi'mM}#eWCcAu@@uQ/'\P~)
TLJ$iL;jUeϋ@@H8z_  dgf&+|p"~2 SS4˦Wl?'/g_R>	ahx{ `^u~b/w0<i_wۼ_z8ƫt0=wc
b5/P+
|,F!SU!.tRrzWH^,,%&8!:_3>LqkoG(Jo:Czu3=
pGD>BR\